/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.Connector;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.handler.DataExchange;

@Environment(value=EnvType.CLIENT)
public class ConnectorClientside
extends Connector {
    private Minecraft client = null;

    ConnectorClientside(DataExchange api) {
        super(api);
    }

    @Override
    public boolean onClient() {
        return true;
    }

    public void onPlayInit(ClientPacketListener handler, Minecraft client) {
        if (this.client != null && this.client != client) {
            BCLib.LOGGER.warning("Client changed!", new Object[0]);
        }
        this.client = client;
        for (DataHandlerDescriptor desc : this.getDescriptors()) {
            ClientPlayNetworking.registerReceiver((ResourceLocation)desc.IDENTIFIER, (_client, _handler, _buf, _responseSender) -> this.receiveFromServer(desc, _client, _handler, _buf, _responseSender));
        }
    }

    public void onPlayReady(ClientPacketListener handler, PacketSender sender, Minecraft client) {
        for (DataHandlerDescriptor desc : this.getDescriptors()) {
            BaseDataHandler h;
            if (!desc.sendOnJoin || (h = desc.JOIN_INSTANCE.get()).getOriginatesOnServer()) continue;
            h.sendToServer(client);
        }
    }

    public void onPlayDisconnect(ClientPacketListener handler, Minecraft client) {
        for (DataHandlerDescriptor desc : this.getDescriptors()) {
            ClientPlayNetworking.unregisterReceiver((ResourceLocation)desc.IDENTIFIER);
        }
    }

    void receiveFromServer(DataHandlerDescriptor desc, Minecraft client, ClientPacketListener handler, FriendlyByteBuf buf, PacketSender responseSender) {
        BaseDataHandler h = desc.INSTANCE.get();
        h.receiveFromServer(client, handler, buf, responseSender);
    }

    public void sendToServer(BaseDataHandler h) {
        if (this.client == null) {
            throw new RuntimeException("[internal error] Client not initialized yet!");
        }
        h.sendToServer(this.client);
    }
}

